
Public Class Dinosaur
   Private m_Name As String
   Public Size As Integer
   Public Property Name() As String
      Get
         Name = m_Name
      End Get
      Set(ByVal Value As String)
         m_Name = Value
      End Set
   End Property
End Class

Public MustInherit Class AbstractDinosaur
    Implements IComparable, ICarnivore
       Private m_Name As String
   Public Size As Integer
    Public Function CompareTo(ByVal obj As Object) _
           As Integer Implements IComparable.CompareTo
        Dim dino As AbstractDinosaur
        dino = CType(obj, AbstractDinosaur)
        Return Me.Size.CompareTo(dino.Size)
    End Function
    Public Property Name() As String
        Get
            Name = m_Name
        End Get
        Set(ByVal Value As String)
            m_Name = Value
        End Set
    End Property
    Public Function CanIEatU(ByVal dino As AbstractDinosaur) _
       As Boolean Implements ICarnivore.CanIEatU
        If Me.Size > dino.Size Then
            CanIEatU = True
        Else
            CanIEatU = False
        End If
    End Function


End Class

Public Class Allosaurus
   Inherits AbstractDinosaur
   Public NumClaws As Integer
End Class

Public Class Diplodocus
   Inherits AbstractDinosaur
   Public FavoriteVeggie As String
End Class

Public Class TRex
   Inherits AbstractDinosaur
   Public NumClaws As Integer
End Class

Public Interface ICarnivore
    Function CanIEatU(ByVal dino As AbstractDinosaur) As Boolean
End Interface